unit fRTFtoHTML;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, StdCtrls, ComCtrls, ExtCtrls;

type
  TConvertOptions = record
    html_type: Integer;			      //0-XHTML, 1- HTML, 2-HTML+CSS
    Title     : Array[0..119] of Char;        //Page title
    Extension : Array[0..9] of Char;          //for example, ".html"
    Font_face : Array[0..49] of Char;         //for example, "Arial" or "Times New Roman"
    Font_size : Array[0..9] of Char;          //for example ,"10"
    preserve_images: Integer;	              //0-no, 1 - yes
    preserve_font_face: Integer;              //0-no, 1 - yes
    preserve_font_size: Integer;              //0-no, 1 - yes
    preserve_font_color: Integer;             //0-no, 1 - yes
    preserve_hyperlinks: Integer;             //0-no, 1 - yes
    table_borders: Integer;		      //0-invisble, 1 - visible
    encoding: Integer;			      {Windows_1250=0, Windows_1251=1, Windows_1252=2, Windows_1253=3,
                                   Windows_1254=4, Windows_1255=5, Windows_1256=6, Windows_1257=7,
                                   Windows_1258=8, ISO_8859_1=9,	ISO_8859_2=10,	ISO_8859_3=11,
                                   ISO_8859_4=12, ISO_8859_5=13,	ISO_8859_6=14,	ISO_8859_7=15,
                                   ISO_8859_8=16, ISO_8859_9=17,	KOI8_R=18,		UTF_8=19	}
    html_parts: Integer;		       //0-html Complete, 1 - only between <body>..</body>
    image_folder: Array[0..499] of Char;       //folder where image will be stored
    CSS_style_name: Array[0..34] of Char; //style name, for example "ts"
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    RtfName: TEdit;
    HtmlName: TEdit;
    memOutput: TMemo;
    Button2: TButton;
    cmbType: TComboBox;
    result: TLabel;
    rtfInput: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    cmbParts: TComboBox;
    Label5: TLabel;
    StyleName: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure cmbTypeChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure cmbPartsChange(Sender: TObject);
  private
    FConvertOptions: TConvertOptions;
  public
  end;

  function rtftohtml_string(AHTML: string; ARTF: string; AOptions: TConvertOptions): pchar;
  cdecl; external 'rtftohtml_sautinsoft.dll' name 'rtftohtml_string';
  function rtftohtml_file(RtfFile: pchar; HtmlFile: pchar; AOptions: TConvertOptions): integer;
  cdecl; external 'rtftohtml_sautinsoft.dll' name 'rtftohtml_file';
  function flushlist(): integer;
  cdecl; external 'rtftohtml_sautinsoft.dll' name 'flushlist';


var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  LoadLibrary('rtftohtml_sautinsoft.dll');
  cmbType.ItemIndex := 0;
  FConvertOptions.encoding := 9;
  FConvertOptions.extension := '.htm';
  FConvertOptions.font_face := 'Verdana';
  FConvertOptions.font_size := '10';
  FConvertOptions.html_parts := 0;
  FConvertOptions.Title := 'Title';
  FConvertOptions.preserve_images:=1;
  FConvertOptions.preserve_font_face:=1;
  FConvertOptions.preserve_font_size:=1;
  FConvertOptions.preserve_font_color:=1;
  FConvertOptions.preserve_hyperlinks:=1;
  FConvertOptions.table_borders:=1;
  FConvertOptions.CSS_style_name:= 'ts';
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  lInString: string;
  lOutString: pchar;
begin
  memOutput.Clear;
  lInString := rtfInput.Text;
  lOutString :=nil;
 // FConvertOptions.CSS_style_name:=StyleName.Text;
  memOutput.Lines.Text := rtftohtml_string(pchar(lInString), lOutString, FConvertOptions);
end;

procedure TForm1.cmbTypeChange(Sender: TObject);
begin
  case cmbType.ItemIndex of
    0: FConvertOptions.html_type := 0; //xhtml
    1: FConvertOptions.html_type := 1; //html
    2: FConvertOptions.html_type := 2; //html + CSS
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  convert_code:integer;
begin
//  FConvertOptions.CSS_style_name:=StyleName.Text;
  convert_code:=rtftohtml_file(pchar(RtfName.Text), pchar(HtmlName.Text), FConvertOptions);
  flushlist(); //release memory
  case convert_code of
    0: result.Caption:='Converting OK';
    2: result.Caption:='Not enough memory';
    3: result.Caption:='Can''t create HTML file';
    4: result.Caption:='Can''t open RTF file';
    5: result.Caption:='RTF file has zero length';
  else
       result.Caption:='Unknown Error';
  end;
end;

procedure TForm1.cmbPartsChange(Sender: TObject);
begin
  case cmbParts.ItemIndex of
    0: FConvertOptions.html_parts:= 0; //html
    1: FConvertOptions.html_parts:= 1; //body
  end;
end;

end.
